<?php

namespace App\Controllers\Frontend\Ajax;

use App\Controllers\BaseController;
use App\Models\StoreModel;

class Locator extends BaseController
{
    public function index()
    {
        log_message('debug', '🚨 Locator index() is running THIS version');
        $data = json_decode($this->request->getBody(), true);
        $page = max((int) ($data['page'] ?? 1), 1);
        $keyword = $data['keyword'] ?? '';
        $category = $data['category'] ?? '';
        $location = $data['location'] ?? '';

        $limit = 12;
        $offset = ($page - 1) * $limit;

        $storeModel = new StoreModel();
        $builder = $storeModel;

        if ($keyword) {
            $builder = $builder->groupStart()
                ->like('name', $keyword)
                ->orLike('description', $keyword)
                ->groupEnd();
        }

        if ($category) {
            $builder = $builder->where('category', $category);
        }

        $stores = $builder->findAll($limit, $offset);

        $html = '';
        foreach ($stores as $store) {
            $html .= view('partials/store_card', ['store' => $store]);
        }

        return $this->response->setBody($html);
    }
}
